/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.outconn;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.CommManager;
import com.ibm.hwmca.fw.rcs.conndata.PassthruInfo;
import com.ibm.hwmca.fw.rcs.outconn.AddPassThruSystemBean;
import com.ibm.hwmca.fw.rcs.outconn.EditPassThruSystemBean;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityConstants;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConnectivityTasklet;
import com.ibm.hwmca.fw.rcs.outconn.PassThruSystemsBean;
import com.ibm.hwmca.fw.rcs.outconn.TestPassThruSystemBean;
import com.ibm.hwmca.fw.rcs.outconn.TestPassThruSystemThread;
import com.ibm.hwmca.fw.rcs.path.PathPlatform;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PassThruSystemsTasklet
extends PanelTasklet
implements OutboundConnectivityConstants {
    private static final String TRACE_MASKT = "XRCSPTTT";
    private static final String TRACE_MASKF = "XRCSPTTF";
    private static final String TRACE_MASKD = "XRCSPTTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-PThrTskl");
    private PassThruSystemsBean passthruBean;
    private TestPassThruSystemThread testPassthruThread;
    private PathPlatform pathPlatform = null;

    public PassThruSystemsTasklet() {
        Trace.trace(TRACE_MASKT, "<> PassThruSystemsTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        this.deactiviateTestThread();
        super.destroy();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.pathPlatform = (PathPlatform)request.getData("PathPlatform");
                this.passthruBean = new PassThruSystemsBean();
                this.passthruBean.setBeanName("PassThruSystemsBean");
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                this.passthruBean.setCallHomeServer(outConfigData.isCallHomeServer());
                this.passthruBean.setAllowPassThru(outConfigData.isAllowPassthru());
                this.passthruBean.setPassThruSystems(outConfigData.getPassthruInfo());
                this.passthruBean.setCallHomeServers(this.queryCallHomeServers());
                response.replace("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "PassThruSystemsPanel", this.passthruBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("PassThruSystemsPanel")) {
                    this.servicePassThruSystemsPanel(request, response);
                } else if (source.equals("AddPassThruSystemPanel")) {
                    this.serviceAddPassThruSystemPanel(request, response);
                } else if (source.equals("EditPassThruSystemPanel")) {
                    this.serviceEditPassThruSystemPanel(request, response);
                } else if (source.equals("TestPassThruSystemPanel")) {
                    this.serviceTestPassThruSystemPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void servicePassThruSystemsPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> servicePassThruSystemsPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("OpenAddPanel")) {
            AddPassThruSystemBean addPassthruBean = new AddPassThruSystemBean();
            addPassthruBean.setBeanName("AddPassThruSystemBean");
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "AddPassThruSystemPanel", addPassthruBean);
        } else if (command.equals("AddPassThruSystem")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("PassThruInfo", request.getData("PassThruInfo"));
            response.update("PassThruSystemsBean", data);
        } else if (command.equals("OpenEditPanel")) {
            PassthruInfo passthruInfo = (PassthruInfo)request.getData("PassThruInfo");
            EditPassThruSystemBean editPassthruBean = new EditPassThruSystemBean();
            editPassthruBean.setBeanName("EditPassThruSystemBean");
            editPassthruBean.setPassthruInfo((PassthruInfo)request.getData("PassThruInfo"));
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "EditPassThruSystemPanel", editPassthruBean);
        } else if (command.equals("UpdatePassThruSystem")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("PassThruInfo", request.getData("PassThruInfo"));
            response.update("PassThruSystemsBean", data);
        } else if (command.equals("OpenTestPanel")) {
            PassthruInfo passthruInfo = (PassthruInfo)request.getData("PassThruInfo");
            TestPassThruSystemBean testPassthruBean = new TestPassThruSystemBean();
            testPassthruBean.setBeanName("TestPassThruSystemrBean");
            testPassthruBean.setPassthruInfo((PassthruInfo)request.getData("PassThruInfo"));
            response.openModalChild("com.ibm.hwmca.fw.rcs.outconn.res.OutboundConnRes", "TestPassThruSystemPanel", testPassthruBean);
        } else if (command.equals("Commit")) {
            PassThruSystemsBean bean = (PassThruSystemsBean)request.getData("Bean");
            if (bean != null) {
                OutboundConnectivityTasklet outConnTasklet = (OutboundConnectivityTasklet)this.getParent();
                OutboundConfigData outConfigData = outConnTasklet.getOutboundConfigData();
                outConfigData.setAllowPassthru(bean.isAllowPassThru());
                outConfigData.setPassthruInfo(bean.getPassThruSystems());
            }
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- servicePassThruSystemsPanel()");
    }

    private void serviceAddPassThruSystemPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceAddPassThruSystemPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            response.dispose();
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "PassThruSystemsPanel");
            newRequest.setData("Command", "AddPassThruSystem");
            newRequest.setData("PassThruInfo", request.getData("PassThruInfo"));
            this.postRequest("PassThruSystemsBean", newRequest);
        } else if (command.equals("Cancel")) {
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceAddPassThruSystemPanel()");
    }

    private void serviceEditPassThruSystemPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceEditPassThruSystemPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            response.dispose();
            PanelTaskletRequest newRequest = new PanelTaskletRequest();
            newRequest.setData("Source", "PassThruSystemsPanel");
            newRequest.setData("Command", "UpdatePassThruSystem");
            newRequest.setData("PassThruInfo", request.getData("PassThruInfo"));
            this.postRequest("PassThruSystemsBean", newRequest);
        } else if (command.equals("Cancel")) {
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceEditPassThruSystemPanel()");
    }

    private void serviceTestPassThruSystemPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceTestPassThruSystemPanel");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Start")) {
            PassthruInfo passthruInfo = (PassthruInfo)request.getData("PassThruInfo");
            this.testPassthruThread = new TestPassThruSystemThread(this, passthruInfo, this.pathPlatform);
            this.testPassthruThread.start();
            response.noAction();
        } else if (command.equals("Stop")) {
            this.deactiviateTestThread();
            response.noAction();
        } else if (command.equals("UpdateStatus")) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("StatusInfo", request.getData("StatusInfo"));
            response.update("TestPassThruSystemrBean", data);
        } else if (command.equals("TestComplete")) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("Command", command);
            response.update("TestPassThruSystemrBean", data);
        } else if (command.equals("Cancel")) {
            this.deactiviateTestThread();
            response.dispose();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceTestPassThruSystemPanel()");
    }

    private void deactiviateTestThread() {
        Trace.trace(TRACE_MASKT, "-> deactivateTestThread()");
        if (this.testPassthruThread != null) {
            this.testPassthruThread.cancel();
        } else {
            Trace.trace(TRACE_MASKF, "No test thread active");
        }
        Trace.trace(TRACE_MASKT, "<- deactivateTestThread()");
    }

    private List queryCallHomeServers() {
        Trace.trace(TRACE_MASKT, "-> queryCallHomeServers()");
        ArrayList<PassthruInfo> servers = new ArrayList<PassthruInfo>();
        CommManager commMgr = CommManager.getCommManager();
        Set machineIds = commMgr.getCallHomeServers();
        Iterator iterator = machineIds.iterator();
        while (iterator.hasNext()) {
            MachineId machineId = (MachineId)iterator.next();
            String name = machineId.getName();
            String ipAddr = commMgr.getIpAddress(machineId);
            PassthruInfo server = new PassthruInfo(ipAddr, name);
            servers.add(server);
        }
        Trace.trace(TRACE_MASKT, "<- queryCallHomeServers()");
        return servers;
    }
}

